#ifndef quicksort_included
#define quicksort_included

/* Szybkie Sortowanie zob. Robert Lafore "Struktury danych i algorytmy w C++", s.235 lub Numerical Recipes in C */

//Wykorzystamy qsort z biblioteki standardowej
#include <stdlib.h>

/*
Skladnia
void qsort(void *base, size_t nelem, size_t width, int (_USERENTRY *fcmp)(const void *, const void *));
           zbior do sort,, il.elem,  wielkosc elementu, funkcja porownujaca


compare_function ma przyjmowac dwa wskazniki (elem1 i elem2) i zwracac
<0 jezeli	*elem1  < *elem2
0 jezeli 	*elem1 == *elem2
>0 jezeli	*elem1  > *elem2

zob. help do qsort
*/


typedef double qstype;

void quicksort(qstype* A, int const A_ile)
{
int compare_function(const void *,const void *); //deklaracja funkcji porownujacej
qsort((void *)A, A_ile, sizeof(A[0]), compare_function);
return;
}

int compare_function(const void *pAi,const void *pAj)
{
int sgn(qstype); //deklaracja sgn
return sgn( (*(qstype*)pAi) - (*(qstype*)pAj) ); //wpierw rzutowanie na wskaniz do qstype (qstype*)pAi, a nastepnie z tego odczytana wartosc *(...)
}

int sgn(qstype arg)
{
int wynik;
if (arg>0) wynik=1;
if (arg==0) wynik=0;
if (arg<0) wynik=-1;
return wynik;
}



#endif
